# 키(Key)
키는 데이터베이스에서 조건에 만족하는 관계의 행을 찾거나 순서대로 정렬할 때 다른 행과 구별할 수 있는 유리한 기준이 되는 속성의 집합이다.  
종류에는 크게 6가지가 있다.
- 슈퍼 키 (Super Key)
- 복합 키 (Composite Key)
- 후보 키 (Candidate Key)
- 기본 키 (Primary Key)
- 대체 키 (Alternate Key)
- 외래 키 (Foreign Key)

<img width="400" src="https://github.com/da-in/tech-interview-study/assets/102718303/9cba7363-f166-4263-ac4f-629856937143">


## 슈퍼 키(super key)

- 테이블에서 각 행을 유일하게 식별할 수 있는 하나 또는 그 이상의 속성들의 집합이다.
- 유일성만 만족하면 슈퍼키가 될 수 있다.
>**유일성** : 하나의 키로 특정 행을 바로 찾아낼수 있는 고유한 데이터 속성을 말한다. 예를 들어 전국에서 나를 구별할 수 있는 유일하고 고유한 속성은 주민번호이다. 주민번호는 전국민이 모두 겹치지 않아 유일하고 고유한 구별 방법으로 쓰인다.

<img width="450" alt="스크린샷 2022-12-20 오후 11 59 16" src="https://user-images.githubusercontent.com/70997596/208697678-30243be3-9426-4b37-9890-fa0e9ddaf030.png">

</br>

## 후보 키(candidate key)
- 테이블에서 각 행을 유일하게 식별할 수 있는 **최소한**의 속성들의 집합으로 기본키가 될 수 있는 후보들이다.
- 유일성과 최소성을 동시에 만족해야한다.
- 슈퍼키들 중에서 속성의 수가 최소가 되는 슈퍼키가 후보키가 된다.
>**최소성** : 키를 구성하는 속성들 중 가장 최소로 필요한 속성들로만 키를 구성하는 성질을 말한다.

<img width="450" alt="스크린샷 2022-12-20 오후 11 59 25" src="https://user-images.githubusercontent.com/70997596/208697710-db5f1094-cb5e-498a-88f4-379dd633e029.png">

>이름 + 나이 슈퍼키는 속성의 개수가 다른 것보다 많기 때문에 최소성을 만족하지 못해서 후보키가 될 수 없다.

</br>

## 기본 키(primary key)
- 후보키들 중에서 하나를 선택한 키로 유일성과 최소성을 만족하는 속성이다.
- 테이블에서 기본키는 오직 1개만 지정할 수 있다.
- 기본키는 테이블 안에서 유일하게 각 행들을 구별할 수 있도록 쓰인다.
- 기본키는 **NULL** 값을 절대 가질수 없고, 중복된 값을 가질 수 없다.
- 각 행들을 구별하려면 값이 없어선 안되고, 중복 되어서도 안되기 때문이다.

<img width="450" alt="스크린샷 2022-12-21 오전 12 01 10" src="https://user-images.githubusercontent.com/70997596/208697761-39c2cdcf-d6d2-4424-b650-ea31ff0e032a.png">

</br>

## 대체 키(alternate key)
- 후보키가 두 개 이상일 경우 그 중에서 하나를 기본키로 지정하고 남은 후보키들을 대체키라고 한다.
- 따라서 대체키는 기본키로 선정되지 않은 후보키이다.

<img width="450" alt="스크린샷 2022-12-21 오전 12 01 21" src="https://user-images.githubusercontent.com/70997596/208697798-33f44263-ff61-4e2d-a05d-8c82fabffa9d.png">

>학번이 기본키가 되고 남은 후보키인 주민번호는 대체키가 된다. 만약 학번 기본키가 없어지게 되면 주민번호는 없어진 기본키를 대체할 수 있게된다.

</br>

## 복합 키(composite key)
- 하나의 속성으로는 기본키가 될 수 없는 경우는 둘 이상의 컬럼을 묶어서 식별자로 정의해야 하는데, 이를 복합키라고 한다.  
>이슈는 복합키 중에 어떤 컬럼을 먼저 둘 것인가 하는 것이다. 컬럼을 기본키로 정의하게 되면 기본적으로 해당 컬럼에 유니크한 클러스터드 인덱스가 정의되며, 이럴 경우 먼저 정의한 컬럼을 기준으로 인덱스가 생성되기 때문에 복합키 중에서 주로 조회의 조건으로 사용되는 컬럼을 먼저 정의하는 것이 성능 향상을 위해 도움이 된다. 

<br>

## 외래 키(foreign key)
- 테이블이 다른 테이블의 데이터를 참조하여 테이블간의 관계를 연결하는 것이다.
- 다른 테이블의 데이터를 참조할 때 없는 값을 참조할 수 없도록 제약을 주는 것이다.
- 예를 들어 참조 될 테이블(A)이 먼저 만들어지고 참조하는 테이블(B)에 값이 입력되어야 한다.
- 이때, B에 입력된 A의 값은 A에서의 기본키(Primary Key)로 설정되어 있어야한다.
- 외래키는 참조되는 테이블의 기본키와 동일한 키 속성을 가진다.
- 참조되는 부모 테이블이 먼저 생성된 뒤 데이터를 넣고, 참조하는 자식 테이블이 다음에 생겨야 한다.
- 따라서 부모 테이블은 먼저 삭제될 수 없다.
  - 부모테이블을 참조하는데 부모테이블이 삭제되면 자식테이블은 참조하는 것이 없어지기 때문에 외래키 오류가 생긴다.
- 외래키 관계에서 부모테이블을 삭제하려면 자식테이블 먼저 삭제한 후 부모테이블을 삭제 해야한다.

<img width="450" alt="스크린샷 2022-12-20 오후 11 55 27" src="https://user-images.githubusercontent.com/70997596/208697831-10e2cdf7-0c83-440e-a441-afd7fa4daa33.png">

>부모 테이블은 학생 테이블, 자식 테이블은 수강 테이블일 때, 학생테이블은 학번이 **기본키이자 참조되는 참조키**이다. 반면 수강테이블은 학번이 **참조하는 키이자 외래키**이다.

</br>
  
## 자연 키(Natural Key) VS 대리 키(surrogate key)
**자연 키**  
- 기본키만을 위한 데이터가 아니라 비즈니스 모델에서 자연스레 나오는 속성으로 기본키를 정하는 것 ex) email, ID 등등  

**대리 키**  
- 대리키는 식별자가 너무 길거나 여러 개의 속성으로 구성되어 있는 경우 인위적으로 추가하는 식별자로, 인공키라고도 부른다. 
- 한 실체에서 식별자가 여러 속성으로 구성된 경우는 데이터를 수정하거나 검색을 하는데 수행 속도가 떨어질 수 있다. 
- 실체간에 관계가 생길 때 부모의 기본키가 자식의 외부키로 공유 되는데, 대리 키를 사용하면 외부키가 단일해지기 때문에 조인의 속도를 향상시키기 위해 많이 사용한다.

</br>

----

## 출처
https://dog-foot-story.tistory.com/60  
https://inpa.tistory.com/entry/DB-%F0%9F%93%9A-%ED%82%A4KEY-%EC%A2%85%EB%A5%98-%F0%9F%95%B5%EF%B8%8F-%EC%A0%95%EB%A6%AC
https://velog.io/@kon6443/DB-%EA%B8%B0%EB%B3%B8%ED%82%A4-%EC%99%B8%EB%9E%98%ED%82%A4-%ED%9B%84%EB%B3%B4%ED%82%A4-%EB%B3%B5%ED%95%A9%ED%82%A4-%EA%B0%9C%EB%85%90-4x1bgz5w
